varying vec2 		texcoord;
uniform sampler2D 	HDRTex;
uniform sampler2D 	lumTex;

uniform float 		lumAvg;
float				lum;


float A = 0.15;
float B = 0.50;
float C = 0.10;
float D = 0.20;
float E = 0.02;
float F = 0.30;
float W = 20.0;//11.2;

vec3 Uncharted2Tonemap(vec3 x)
{
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}
	
void main()
{
	/*float 	AVG=pow(texture2D(lumTex,texcoord).r,2.0)*lumAvg;
	float a= 1.03 - (2.0/( 2.0 + log(AVG + 1.0) ));
	
	vec4	HDRColor=texture2D(HDRTex,texcoord);
	lum=dot(vec3(0.27, 0.67, 0.06),HDRColor.xyz);
	
	float 	lumRel=a*lum/AVG;
	float	lumMap=lumRel/(1.0+lumRel);
	
	//float lumMap = pow(lumMap,2.0);
	gl_FragColor = max(vec4(0.0,0.0,0.0,0.0),HDRColor*vec4(lumMap));*/

	//float 	AVG=texture2D(lumTex,texcoord).r*lumAvg;
	/*vec3 	texColor = texture2D(HDRTex, texCoord).rgb;
	texColor *= 16;//AVG;  // Hardcoded Exposure Adjustment
	texColor = texColor/(1.0+texColor);
	vec3 retColor = pow(texColor,1.0/2.2);
	gl_FragColor=vec4(retColor,1);*/
	
	vec3 texColor = texture2D(HDRTex, texcoord).rgb;
	float 	AVG=texture2D(lumTex,texcoord).r;
	lum=dot(vec3(0.27, 0.67, 0.06),texColor.xyz);
	texColor *= lum/AVG;  // Hardcoded Exposure Adjustment
	float ExposureBias = lumAvg;//2.0f;
	vec3 curr = Uncharted2Tonemap(ExposureBias*texColor);
	vec3 whiteScale = 1.0/Uncharted2Tonemap(vec3(W));
	vec3 color = curr*whiteScale;
	vec3 retColor = pow(color,vec3(1.0/2.2));

	gl_FragColor=vec4(retColor,1.0);
}
